<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop;

use Gls\GlsPoland\PrestaShop\MessageHandler\CommandHandlerInterface;
use PrestaShop\PrestaShop\Core\CommandBus\CommandBusInterface;
use Psr\Container\ContainerInterface;
use Symfony\Contracts\Service\ServiceProviderInterface;

/**
 * @internal
 */
class CommandBus implements CommandBusInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @param ServiceProviderInterface<CommandHandlerInterface> $container locator of command handlers by command name
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    /**
     * @param object $command
     */
    public function handle($command)
    {
        $handler = $this->container->get(get_class($command));
        assert($handler instanceof CommandHandlerInterface);

        return $handler->handle($command);
    }
}
