<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\TypeExtension;

use Gls\GlsPoland\Form\Type\SearchableMaterialChoiceTableType;
use PrestaShopBundle\Form\Admin\Type\Material\MaterialChoiceTableType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @deprecated since 1.1.0. Use {@see SearchableMaterialChoiceTableType} instead.
 */
final class MaterialChoiceTableSearchExtension extends AbstractTypeExtension
{
    public static function getExtendedTypes(): iterable
    {
        return [MaterialChoiceTableType::class];
    }

    public function getExtendedType(): string
    {
        return MaterialChoiceTableType::class;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefaults([
                'searchable' => false,
                'search_min_count' => 9,
            ])
            ->setAllowedTypes('searchable', 'bool')
            ->setAllowedTypes('search_min_count', 'int');
    }

    public function finishView(FormView $view, FormInterface $form, array $options): void
    {
        $class = $view->vars['attr']['class'] ?? '';
        $view->vars['attr']['class'] = $class . ' js-choice-table-container';
        $view->vars['searchable'] = $options['searchable'] && count($view) >= $options['search_min_count'];
    }
}
