<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Services;

use Gls\GlsPoland\AdePlus\Common;
use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class Services implements ResultInterface, \JsonSerializable
{
    public const CASH_ON_DELIVERY = 'COD';
    public const SATURDAY_DELIVERY = 'SAT';
    public const DOCUMENT_RETURN = 'ROD';
    public const DELIVERY_BEFORE_10 = '10:00';
    public const DELIVERY_BEFORE_12 = '12:00';

    /**
     * @var string
     */
    private $srv_ade;

    /**
     * @var Common\Services
     */
    private $srv_bool;

    public function getServicesAde(): string
    {
        return $this->srv_ade;
    }

    public function getServices(): Common\Services
    {
        return $this->srv_bool;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
