<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Fault;

use Gls\GlsPoland\Soap\Client\Caller\CallerInterface;
use Gls\GlsPoland\Soap\Client\Exception\SoapFault;
use Gls\GlsPoland\Soap\Client\Type\RequestInterface;
use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class FaultConvertingCaller implements CallerInterface
{
    private $caller;
    private $converter;

    public function __construct(CallerInterface $caller, FaultConverterInterface $converter)
    {
        $this->caller = $caller;
        $this->converter = $converter;
    }

    public function call(string $method, RequestInterface $request): ResultInterface
    {
        try {
            return $this->caller->call($method, $request);
        } catch (SoapFault $exception) {
            throw $this->converter->convert($exception);
        }
    }
}
